<?php
/**
 * Template Name: Our Fleet
 * Full width template for Lighthouse theme
 *
 * Please browse readme.txt for credits and forking information
 * @package Lighthouse
 */

get_header(); 
$id = get_the_ID();
?>

<div class="container">
    <div class="row">
        <div id="primary" class="col-md-12 content-area">
            <main id="main" class="site-main" role="main">

                <?php while ( have_posts() ) : the_post(); ?>

                    <?php get_template_part( 'template-parts/content', 'page' ); ?>

                    <?php
                        // If comments are open or we have at least one comment, load up the comment template.
                        if ( comments_open() || get_comments_number() ) :
                            comments_template();
                        endif;
                    ?>

                <?php endwhile; // End of the loop.  
                ?>
            </main><!-- #main -->
        </div><!-- #primary -->
    </div> <!--.row-->            
</div><!--.container--> 
<?php if( have_rows('tugs_gallery') ) { ?>
<div class="gallery-modal" id="tugs-gallery-modal">
	<div class="gallery-modal_content">
		<div class="gm-header">
			<h2>Tugs</h2>
		</div>
		<div class="gallery-slider">
			<div class="owl-carousel gallery-carousel">
            <?php while(has_sub_field('tugs_gallery')): ?>
				<div class="gallery-item">
					<div class="gallery_img">
						<img src="<?php the_sub_field('image'); ?>" class="img-fluid" />
					</div>
					<div class="gallery_text">
						<p><?php the_sub_field('title'); ?></p>
					</div>
				</div>	
            <?php endwhile; ?>    				
			</div>
		</div>
		<div class="gm-footer text-center">
			<a href="javascript:void(0);" class="btn btn-outline-white gm_close">CLOSE</a>
		</div>
	</div>
</div>
<?php }
if( have_rows('ferries_gallery') ) {
?>
<div class="gallery-modal" id="ferries-gallery-modal">
	<div class="gallery-modal_content">
		<div class="gm-header">
			<h2>Ferries</h2>
		</div>
		<div class="gallery-slider">
			<div class="owl-carousel gallery-carousel">
            <?php while(has_sub_field('ferries_gallery')): ?>
				<div class="gallery-item">
					<div class="gallery_img">
						<img src="<?php the_sub_field('image'); ?>" class="img-fluid" />
					</div>
					<div class="gallery_text">
						<p><?php the_sub_field('title'); ?></p>
					</div>
				</div>	
            <?php endwhile; ?>    			
			</div>
		</div>
		<div class="gm-footer text-center">
			<a href="javascript:void(0);" class="btn btn-outline-white gm_close">CLOSE</a>
		</div>
	</div>
</div>
<?php }
if( have_rows('pilots_gallery') ) {
?>
<div class="gallery-modal" id="pilot-boats-gallery-modal">
	<div class="gallery-modal_content">
		<div class="gm-header">
			<h2>Pilot Boats & Launches</h2>
		</div>
		<div class="gallery-slider">
			<div class="owl-carousel gallery-carousel">
            <?php while(has_sub_field('pilots_gallery')): ?>
				<div class="gallery-item">
					<div class="gallery_img">
						<img src="<?php the_sub_field('image'); ?>" class="img-fluid" />
					</div>
					<div class="gallery_text">
						<p><?php the_sub_field('title'); ?></p>
					</div>
				</div>	
            <?php endwhile; ?>    		
			</div>
		</div>
		<div class="gm-footer text-center">
			<a href="javascript:void(0);" class="btn btn-outline-white gm_close">CLOSE</a>
		</div>
	</div>
</div>
<?php }
if( have_rows('utility_gallery') ) {
?>
<div class="gallery-modal" id="utility-vessels-gallery-modal">
	<div class="gallery-modal_content">
		<div class="gm-header">
			<h2>Utility Vessels</h2>
		</div>
		<div class="gallery-slider">
			<div class="owl-carousel gallery-carousel">
            <?php while(has_sub_field('utility_gallery')): ?>
				<div class="gallery-item">
					<div class="gallery_img">
						<img src="<?php the_sub_field('image'); ?>" class="img-fluid" />
					</div>
					<div class="gallery_text">
						<p><?php the_sub_field('title'); ?></p>
					</div>
				</div>	
          <?php endwhile; ?>      
			</div>
		</div>
		<div class="gm-footer text-center">
			<a href="javascript:void(0);" class="btn btn-outline-white gm_close">CLOSE</a>
		</div>
	</div>
</div>
<?php } ?>
<?php get_footer(); ?>
