<?php
/**
 * Template Name: Media
 * Full width template for Lighthouse theme
 *
 * Please browse readme.txt for credits and forking information
 * @package Lighthouse
 */

get_header(); 
$id = get_the_ID();
?>

<div class="container">
    <div class="row">
        <div id="primary" class="col-md-12 content-area">
            <main id="main" class="site-main" role="main">

                <?php while ( have_posts() ) : the_post(); ?>

                    <?php get_template_part( 'template-parts/content', 'page' ); ?>

                    <?php
                        // If comments are open or we have at least one comment, load up the comment template.
                        if ( comments_open() || get_comments_number() ) :
                            comments_template();
                        endif;
                    ?>

                <?php endwhile; // End of the loop.  
                ?>
            </main><!-- #main -->
        </div><!-- #primary -->
    </div> <!--.row-->            
</div><!--.container--> 
<div class="modal fade media-v_modal" id="media-video_modal" tabindex="-1" role="dialog" aria-labelledby="media-video_modalLabel" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-body">
				<div class="embed-responsive embed-responsive-16by9">
					<iframe class="embed-responsive-item" src="" id="video"  allowscriptaccess="always" allow="autoplay"></iframe>
				</div>
			</div>
		</div>
	</div>
</div>
<script>            
    // Gets the video src from the data-src on each button
jQuery(document).ready(function() {
    var jQueryvideoSrc;
    jQuery(".media-video_link").click(function() {
        jQueryvideoSrc = jQuery(this).data("src");
    });

    jQuery("#media-video_modal").on("shown.bs.modal", function(e) {
        jQuery("#video").attr(
        "src",
        jQueryvideoSrc + "?autoplay=1&amp;modestbranding=1&amp;showinfo=0"
        );
    });
    jQuery("#media-video_modal").on("hide.bs.modal", function(e) {
        jQuery("#video").attr("src", jQueryvideoSrc);
    });
});
</script>
<?php get_footer(); ?>
