<?php 
	
/*** Enqueue scripts and styles */
remove_action( 'woocommerce_before_main_content', 'action_woocommerce_before_main_content', 10, 2 );
function mychildtheme_enqueue_styles() {
    $parent_style = 'parent-style';
   	wp_enqueue_style( 'owlcarouselCss' , get_stylesheet_directory_uri() . '/assets/css/owl.carousel.min.css' );

	wp_enqueue_script( 'owlcarouselJs', get_stylesheet_directory_uri() . '/assets/js/owl.carousel.min.js', array('jquery'), '20120206', true );
 	wp_enqueue_script( 'custom', get_stylesheet_directory_uri() . '/assets/js/custom.js', array('jquery'), '20120206', true );

}
add_action( 'wp_enqueue_scripts', 'mychildtheme_enqueue_styles' );

function media_slider_html( $atts ) {
	global $post;
	$myposts = get_posts( array(
        'post_type'       => 'post',
    ) );
    $html = "";
	foreach ( $myposts as $post ) :
		$src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'thumbnail_size' );
		$post_type = get_field('media_type'); 
		
        if($post_type == 'video'){
			$html.='<div class="media-item">
                <h5>'.get_the_title().'</h5>                                   
                <div class="media-img media-video media-video_link" data-toggle="modal" data-target="#media-video_modal" data-src="'.get_field("video_link").'">	
                    <img src="'.$src[0].'" class="img-fluid">
                </div>
                <div class="media_desc">
                    '.$post->post_content.'
                    <a class="btn btn-outline-white media-video_link" data-toggle="modal" href="#media-video_modal" data-src="'.get_field("video_link").'">Watch Video</a>
                </div>
            </div>';
		}
		elseif($post_type == 'pdf'){
			$html.='<div class="media-item">
                <h5>'.get_the_title().'</h5>                                   
                <div class="media-img">	
                    <img src="'.$src[0].'" class="img-fluid">
                </div>
                <div class="media_desc">
                    '.$post->post_content.'
                    <a class="btn btn-outline-white" href="'.get_field("upload_pdf").'">DOWNLOAD PDF</a>
                </div>
            </div>';
		}
		else{
			$html.='<div class="media-item">
					<h5>'.get_the_title().'</h5>
					<div class="media-img" data-toggle="modal" data-target="media-video_modal">	
						<img src="'.$src[0].'" class="img-fluid">
					</div>
					<div class="media_desc">
						'.$post->post_content.'
						<a class="btn btn-outline-white" href="'.get_post_permalink($post->ID).'">READ MORE</a>
					</div>
				</div>';
		}		
	endforeach;
	return $html;
}
add_shortcode( 'media_slider_html', 'media_slider_html');


?>